*** export.do
*** v1.1
***
*** Export forecasts to .csv files.
***
clear all
set more off
set type double

global path = "$HOME/research/ssur"

*******************************
*** UPDATE THESE PARAMETERS ***
*******************************
* date of first and last forecast to evaluate
local start = tm(1969m11)
local stop = tm(2012m12)

*** V1 UR DATA
tempfile v1ur
use $path/data/rtdata/v1ur.dta, clear
replace v1ur=v1ur/100
tscollap v1ur, to(q) gen(qdate)
qui replace v1ur = round(v1ur,.0001)
tsset qdate, q
save `v1ur'

*** PROCESS GB FORECASTS
tempfile gbur
use $path/data/gb/gbur.dta, clear
reshape long ur_gb, i(gbdate) j(j)
keep if j<5
gen int fcdate=mofd(gbdate)
* fix multiple GBs per month
drop if gbdate==td(29apr1970)
qui replace fcdate=tm(1971m4) if gbdate==td(31mar1971)
qui replace fcdate=tm(1971m5) if gbdate==td(28apr1971)
drop if gbdate==td(02jun1971)
qui replace fcdate=tm(1980m2) if gbdate==td(30jan1980)
*
gen int qdate=qofd(gbdate)+j
qui replace ur_gb = ur_gb/100
drop if ur_gb==.
format fcdate %tm
tsset fcdate qdate, q
keep fcdate qdate ur_gb
qui replace ur_gb = round(ur_gb,.001)
save `gbur', replace

*** PROCESS SPF FORECASTS
tempfile spfur
use $path/data/spf/spf-unemp.dta, clear
drop *avg*
reshape long ru_med, i(qdate) j(j)
rename qdate date
gen int fcdate=mofd(dofq(date))+1
gen int qdate=date+j
gen ur_spf = ru_med/100
drop if ur_spf==.
format fcdate %tm
tsset fcdate qdate, q
keep fcdate qdate ur_spf
qui replace ur_spf = round(ur_spf,.001)
save `spfur', replace

** SSUR FORECASTS
tempfile ssur2
use $path/analysis-bpea/models/rt/rt-ssur2.dta, clear
tsset fcdate mdate, m
* collapse to quarterly
tscollap ur_ssur2, to(q) gen(qdate)
* keep horizon t+0 to t+4
keep if qdate>=qofd(dofm(fcdate)) & qdate<qofd(dofm(fcdate))+5
qui replace ur_ssur2 = round(ur_ssur2,.0001)
save `ssur2'

** CONSTANT HAZRATE FORECASTS
tempfile ssur2hr
use $path/analysis-bpea/models/contrib/rt-contrib.dta, clear
rename ur_s ur_ssur_s
rename ur_f ur_ssur_f
tsset fcdate mdate, m
* collapse to quarterly
tscollap ur_ssur_s ur_ssur_f, to(q) gen(qdate)
* keep horizon t+0 to t+4
keep if qdate>=qofd(dofm(fcdate)) & qdate<qofd(dofm(fcdate))+5
qui replace ur_ssur_s = round(ur_ssur_s,.0001)
qui replace ur_ssur_f = round(ur_ssur_f,.0001)
save `ssur2hr'

** u* FORECASTS
tempfile ustar
use $path/analysis-bpea/models/ustar/rt-ustar.dta, clear
tsset fcdate mdate, m
* collapse to quarterly
tscollap ur_ustar, to(q) gen(qdate)
* keep horizon t+0 to t+4
keep if qdate>=qofd(dofm(fcdate)) & qdate<qofd(dofm(fcdate))+5
qui replace ur_ustar = round(ur_ustar,.0001)
save `ustar'

** ARIMA FORECASTS
tempfile arima
use $path/analysis-bpea/models/arima/rt-arima-15y.dta, clear
rename ur_ ur_arima
tsset fcdate mdate, m
* collapse to quarterly
tscollap ur_arima, to(q) gen(qdate)
* keep horizon t+0 to t+4
keep if qdate>=qofd(dofm(fcdate)) & qdate<qofd(dofm(fcdate))+5
qui replace ur_arima = round(ur_arima,.0001)
save `arima'

** VAR FORECASTS
tempfile var
use $path/analysis-bpea/models/var/rt-var.dta, clear
tsset fcdate mdate, m
* collapse to quarterly
tscollap ur, to(q) gen(qdate)
* keep horizon t+0 to t+4
keep if qdate>=qofd(dofm(fcdate)) & qdate<qofd(dofm(fcdate))+5
qui replace ur_var = round(ur_var,.0001)
save `var'

** QRT SSUR-2 FORECASTS
tempfile ssur2qrt
use $path/analysis-bpea/models/qrt/ssur2/qrt-ssur2.dta, clear
tsset fcdate mdate, m
* collapse to quarterly
tscollap ur_ssur2, to(q) gen(qdate)
* keep horizon t+0 to t+4
keep if qdate>=qofd(dofm(fcdate)) & qdate<qofd(dofm(fcdate))+5
qui replace ur_ssur2 = round(ur_ssur2,.0001)
rename ur_ssur2 ur_ssur2_qrt
save `ssur2qrt'

** QRT SSUR-3 FORECASTS
tempfile ssur3qrt
use $path/analysis-bpea/models/qrt/ssur3/qrt-ssur3.dta, clear
tsset fcdate mdate, m
* collapse to quarterly
tscollap ur_ssur3, to(q) gen(qdate)
* keep horizon t+0 to t+4
keep if qdate>=qofd(dofm(fcdate)) & qdate<qofd(dofm(fcdate))+5
qui replace ur_ssur3 = round(ur_ssur3,.0001)
rename ur_ssur3 ur_ssur3_qrt
save `ssur3qrt'


*** MERGE IN FORECASTS
use `ssur2', clear
merge 1:1 fcdate qdate using `gbur', nogen
merge 1:1 fcdate qdate using `spfur', nogen
merge 1:1 fcdate qdate using `ssur2hr', nogen
merge 1:1 fcdate qdate using `arima', nogen
merge 1:1 fcdate qdate using `var', nogen
merge 1:1 fcdate qdate using `ustar', nogen
merge 1:1 fcdate qdate using `ssur2qrt', nogen
merge 1:1 fcdate qdate using `ssur3qrt', nogen
merge m:1 qdate using `v1ur', nogen
tsset fcdate qdate, q

keep if qdate>=tq(1951q1)

foreach var in ssur2 ssur_s ssur_f gb spf arima var ustar ssur2_qrt ssur3_qrt {
  rename ur_`var' ur_`var'_
}
rename v1ur v1ur_

keep if fcdate>=`start'
sort fcdate qdate
by fcdate: gen j = _n
replace j=j-1
keep if j<5
drop qdate

reshape wide ur_ssur2_ ur_ssur_s_ ur_ssur_f_ ur_gb_ ur_spf_ ur_arima_ ur_var_ ur_ustar_ ur_ssur2_qrt ur_ssur3_qrt v1ur_, i(fcdate) j(j)

foreach model in ssur2 ssur_s ssur_f gb spf ustar arima var ssur2_qrt ssur3_qrt {
  outsheet fcdate ur_`model'_0 ur_`model'_1 ur_`model'_2 ur_`model'_3 ur_`model'_4 using ur_`model'.csv, comma replace
}
outsheet fcdate v1ur_* using v1ur.csv, comma replace
!tar czvf forecasts.tar.gz *.csv

if "$S_CONSOLE"=="console" exit, STATA clear
